<p align="center">
    <a href="https://github.com/l3v11/SearchX">
        <img width="200" src="https://cdn.dribbble.com/users/1501052/screenshots/5468049/searching_tickets.gif" alt="SearchX">
    </a>
</p>


<p align="center">

# SearchX

SearchX is a multipurpose Telegram bot written in Python for Google Drive

</p>


## Features

- Search data in Google Drive
- Clone data from Google Drive and GDToT
- Compress data from Google Drive and GDToT
- Extract data from Google Drive and GDToT
- Count data from Google Drive
- Generate mediainfo of media files from Google Drive and URL
- Generate frames of media files from Google Drive and URL
- Generate collage of media files from Google Drive and URL
- Delete data from Google Drive
- Set data permission in Google Drive
- Size Limit support for Clone, Compression and Extraction tasks
- Destination change support for Clone tasks
- MongoDB database support
- Bookmark support for storing Destination Drive IDs into database
- Support for storing the list of authorized users into database
- Index Link support
- Multi-token telegraph support
- Multi-page telegraph page results
- Service Account (SA) support
- Execute shell commands
- Evaluate Python expressions
- Run Python code

## Configuration

These four files are required to run the bot
- [credentials.json](https://github.com/l3v11/SearchX/wiki/Getting-the-Configuration-Files#getting-the-credentialsjson-file)
- [drive_list](https://github.com/l3v11/SearchX/wiki/Getting-the-Configuration-Files#getting-the-drive_list-file)
- [token.json](https://github.com/l3v11/SearchX/wiki/Getting-the-Configuration-Files#getting-the-tokenjson-file)
- [config.env](https://github.com/l3v11/SearchX/wiki/Getting-the-Configuration-Files#setting-up-the-configenv-file)

## Deployment

These two guides are available to deploy the bot
- [Deploying to Heroku](https://github.com/l3v11/SearchX/wiki/Deploying-to-Heroku)
- [Deploying to VPS](https://github.com/l3v11/SearchX/wiki/Deploying-to-VPS)

## Commands

This list of commands is supported by the bot
```
start - Start the bot
find - Search data in Google Drive
clone - Clone data to Google Drive
compress - Compress data to Google Drive
extract - Extract data to Google Drive
count - Count data from Google Drive
minfo - Generate mediainfo of a media file
ss - Generate frames of a media file
col - Generate collage of a media file
cancel - Cancel a task
status - Get status of all tasks
share - Set data permission in Google Drive
del - Delete data from Google Drive
addbm - Add bookmark of a destination drive
rembm - Remove bookmark of a destination drive
bookmarks - Get the list of bookmarked destination drives
auth - Grant authorization of an user
unauth - Revoke authorization of an user
users - Get the list of authorized users
shell - Execute shell commands
eval - Evaluate Python expressions
exec - Execute Python code
clearlocals - Clear the locals
ping - Ping the bot
stats - Get the system statistics
log - Get the log file
restart - Restart the bot
help - Get help
```

## Changelog

> [**Click here**](https://github.com/l3v11/SearchX/wiki/Changelog) to see the list of changes made to the bot

## FAQs

> [**Click here**](https://github.com/l3v11/SearchX/wiki/Frequently-Asked-Questions) to read the answers to 
some of the most common questions and the problems users come across

## Credits

[Levi](https://github.com/l3v11) *(Maintainer)* |
[Shivam Jha](https://github.com/lzzy12) |
[Sreeraj V R](https://github.com/SVR666) |
[TheArchivists](https://github.com/thearchivists) |
[Snape](https://github.com/snape541) |
[Anas](https://github.com/anasty17) |
[Yuuki](https://github.com/xcscxr) |
[Hrutvik](https://github.com/hsj51) |
[SpeedX](https://github.com/SpeedyIndeedy) |
[Agamya Samuel](https://github.com/agamya-samuel)
